// Interface definition for Lentoid HEVC Decoder
// Copyright (C) 2013 Strongene
// Ver: 2.0.1.9
// Date: 2013.06.19
// Author: Strongene

//
// HEVCDecFilter's CLSID:
// {658C5E1C-58E1-43CA-9D10-13735D465576}
//

#pragma once

#ifdef __cplusplus
extern "C" {
#endif

// Lentoid HEVC decoder config interface
[uuid("8862E571-7597-478F-A06F-0A6A1800388E")]
interface ILENTHEVCDecCfg : public IUnknown 
{
	// decode multiple frames in multiple threads
	STDMETHOD(get_ThreadNumber) (int* val) PURE;
    STDMETHOD(put_ThreadNumber) (int val) PURE;

	// DirectShow Quality Control
	// handles the quality control message (true) or passes it upstream (false)
	STDMETHOD(get_QualityControlEnable) (bool* val) PURE;
    STDMETHOD(put_QualityControlEnable) (bool val) PURE;
	// skip no reference B frame when downstream filter send quality control message when sample delay (famine) greater than this threshold in millisecond.
	STDMETHOD(get_QualityControlSkipNoRefBThreshold) (int* val) PURE;
    STDMETHOD(put_QualityControlSkipNoRefBThreshold) (int val) PURE;
};


#ifdef __cplusplus
}
#endif
